# Database Setup Instructions

## Method 1: Using phpMyAdmin (Easiest)

1. **Open phpMyAdmin**
   - Go to `http://localhost/phpmyadmin` in your browser
   - Login with your credentials (usually user: `root`, no password)

2. **Create Database**
   - Click on **Databases** tab
   - Enter database name: `quiz_system`
   - Click **Create**

3. **Import Schema**
   - Select the newly created `quiz_system` database
   - Click **Import** tab
   - Click **Choose File** and select `database_schema.sql`
   - Click **Import**
   - You should see: "Import successful" message

4. **Verify Tables**
   - You should now see these tables in the left panel:
     - users
     - questionnaires
     - questions
     - options
     - student_questionnaire
     - student_attempts
     - student_answers

---

## Method 2: Using MySQL Command Line

1. **Open Terminal/Command Prompt**
   - Windows: Open Command Prompt
   - Mac/Linux: Open Terminal

2. **Login to MySQL**
   ```bash
   mysql -u root -p
   ```
   - Enter password (press Enter if no password)

3. **Create Database**
   ```sql
   CREATE DATABASE quiz_system;
   USE quiz_system;
   ```

4. **Import Schema**
   ```sql
   source /path/to/database_schema.sql
   ```
   
   Or on Windows:
   ```sql
   source C:\path\to\database_schema.sql
   ```

5. **Verify**
   ```sql
   SHOW TABLES;
   ```
   You should see 7 tables listed.

---

## Method 3: Using MySQL GUI Tools

### For MySQL Workbench:
1. Open MySQL Workbench
2. Double-click your local MySQL connection
3. File → Open SQL Script → Select `database_schema.sql`
4. Click the lightning bolt icon to execute
5. Refresh the schema browser to see new database

### For Sequel Pro (Mac):
1. Double-click your connection
2. File → Open → Select `database_schema.sql`
3. Click "Run All" button
4. Database created successfully

---

## Post-Setup: Create Admin Account

### Using phpMyAdmin:
1. Go to `quiz_system` database
2. Click **users** table
3. Click **Insert** tab
4. Fill in these fields:
   - **username:** admin
   - **email:** admin@example.com
   - **password:** Generate hash (see below)
   - **full_name:** Administrator
   - **role:** admin

### Generate Password Hash:

**On Command Line:**
```bash
php -r "echo password_hash('admin123', PASSWORD_BCRYPT);"
```

**Or in PHP file create temp.php with:**
```php
<?php
echo password_hash('admin123', PASSWORD_BCRYPT);
?>
```

Then run: `php temp.php`

Copy the output and paste in password field.

### Direct SQL Insert:

Replace `[HASH]` with actual hash from above:
```sql
INSERT INTO users (username, email, password, full_name, role) 
VALUES ('admin', 'admin@example.com', '[HASH]', 'Administrator', 'admin');
```

Example with actual hash:
```sql
INSERT INTO users (username, email, password, full_name, role) 
VALUES ('admin', 'admin@example.com', '$2y$10$ckAj8R8F8R8F8R8F8R8F8R8F8R8F8R8F8R8F8R8F8R8F8R8F8R8F8R', 'Administrator', 'admin');
```

---

## Verify Installation

### Check Tables:
```sql
SHOW TABLES FROM quiz_system;
```

Expected output:
```
+--------------------------+
| Tables_in_quiz_system    |
+--------------------------+
| options                  |
| questions                |
| questionnaires           |
| student_answers          |
| student_attempts         |
| student_questionnaire    |
| users                    |
+--------------------------+
```

### Check User Created:
```sql
SELECT * FROM quiz_system.users WHERE role = 'admin';
```

Should show your admin user.

---

## Database Backup

### Backup Using Command Line:
```bash
mysqldump -u root -p quiz_system > quiz_system_backup.sql
```

Then enter your MySQL password when prompted.

### Backup From phpMyAdmin:
1. Select `quiz_system` database
2. Click **Export**
3. Select format: **SQL**
4. Click **Go** to download

---

## Database Restore

### From Command Line:
```bash
mysql -u root -p quiz_system < quiz_system_backup.sql
```

### From phpMyAdmin:
1. Select `quiz_system` database
2. Click **Import**
3. Select your backup file
4. Click **Import**

---

## Troubleshooting

### "Access Denied" Error
**Problem:** Can't connect to MySQL
**Solution:**
- Verify MySQL is running
- Check username and password
- For XAMPP: Default is usually `root` with no password

### "Database Already Exists"
**Problem:** Database creation fails
**Solution:**
- Drop existing database:
  ```sql
  DROP DATABASE quiz_system;
  CREATE DATABASE quiz_system;
  ```
- Then re-import schema

### "Table Already Exists"
**Problem:** Error when importing schema
**Solution:**
- Drop and recreate database (see above)

### "Unknown Collation"
**Problem:** Import fails with collation error
**Solution:**
- Edit `database_schema.sql` 
- Change `utf8mb4_unicode_ci` to `utf8_general_ci`
- Save and re-import

---

## Default Test Users

After import, you can create these for testing:

### Admin User
```sql
INSERT INTO users (username, email, password, full_name, role) 
VALUES ('admin', 'admin@example.com', '$2y$10$...', 'Admin User', 'admin');
```

### Student Users
```sql
INSERT INTO users (username, email, password, full_name, role) 
VALUES 
  ('student1', 'student1@example.com', '$2y$10$...', 'John Doe', 'student'),
  ('student2', 'student2@example.com', '$2y$10$...', 'Jane Smith', 'student'),
  ('student3', 'student3@example.com', '$2y$10$...', 'Bob Johnson', 'student');
```

---

## Next Steps

Once database is set up:
1. Update `config.php` with your database credentials
2. Access application at `http://localhost/quiz_system/auth/login.php`
3. Login with admin credentials
4. Create first questionnaire
5. Add students and assign quizzes

---

**Database setup complete! Proceed with config.php configuration.** ✅
