<?php
require_once '../config.php';
require_once '../classes/Report.php';

if (!isAdmin()) {
    redirect(BASE_URL . 'auth/login.php');
}

$report = new Report($conn);
$stats = $report->getClassStatistics();
$page_title = 'Admin Dashboard';
?>
<?php include '../includes/header.php'; ?>

<div class="container">
    <h1>Dashboard</h1>
    
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-label">Total Students</div>
            <div class="stat-value"><?php echo $stats['total_students'] ?? 0; ?></div>
        </div>
        
        <div class="stat-card">
            <div class="stat-label">Total Questionnaires</div>
            <div class="stat-value"><?php echo $stats['total_questionnaires'] ?? 0; ?></div>
        </div>
        
        <div class="stat-card">
            <div class="stat-label">Total Attempts</div>
            <div class="stat-value"><?php echo $stats['total_attempts'] ?? 0; ?></div>
        </div>
        
        <div class="stat-card">
            <div class="stat-label">Class Average</div>
            <div class="stat-value"><?php echo number_format($stats['class_average'] ?? 0, 2); ?>%</div>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <div class="card-title">Quick Actions</div>
        </div>
        <div class="card-content">
            <a href="<?php echo BASE_URL; ?>admin/questionnaires.php" class="btn btn-primary">Create New Questionnaire</a>
            <a href="<?php echo BASE_URL; ?>admin/reports.php" class="btn btn-secondary">View Reports</a>
            <a href="<?php echo BASE_URL; ?>admin/manage-students.php" class="btn btn-outline">Manage Students</a>
        </div>
    </div>
</div>

</body>
</html>
