<?php
require_once '../config.php';
require_once '../classes/Question.php';
require_once '../classes/Option.php';

if (!isAdmin()) {
    redirect(BASE_URL . 'auth/login.php');
}

$question_id = intval($_GET['question_id'] ?? 0);
$question = new Question($conn);
$option = new Option($conn);

$q = $question->getById($question_id);

if (!$q) {
    redirect(BASE_URL . 'admin/questionnaires.php');
}

$message = '';
$error = '';

// Add option
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'add_option') {
        $option_text = sanitize($_POST['option_text'] ?? '');
        $is_correct = isset($_POST['is_correct']) ? 1 : 0;
        
        if ($q['question_type'] !== 'short_answer') {
            $result = $option->add($question_id, $option_text, $is_correct);
            
            if ($result['success']) {
                header("Location: " . $_SERVER['REQUEST_URI']);
                exit();
            } else {
                $error = 'Failed to add option';
            }
        }
    } elseif ($_POST['action'] === 'delete_option') {
        $option_id = intval($_POST['option_id'] ?? 0);
        $option->delete($option_id);
        header("Location: " . $_SERVER['REQUEST_URI']);
        exit();
    }
}

$options_result = $option->getByQuestion($question_id);
$options = $options_result->fetch_all(MYSQLI_ASSOC);

$page_title = 'Manage Options';
?>
<?php include '../includes/header.php'; ?>

<div class="container">
    <div class="card">
        <div class="card-header">
            <div class="card-title">Question: <?php echo htmlspecialchars($q['question_text']); ?></div>
        </div>
    </div>
    
    <?php if ($q['question_type'] !== 'short_answer'): ?>
        <div class="card">
            <div class="card-header">
                <div class="card-title">Add Option</div>
            </div>
            <div class="card-content">
                <?php if ($error): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <form method="POST" action="">
                    <input type="hidden" name="action" value="add_option">
                    
                    <div class="form-group">
                        <label for="option_text">Option Text</label>
                        <input type="text" id="option_text" name="option_text" required>
                    </div>
                    
                    <div class="form-group">
                        <label>
                            <input type="checkbox" name="is_correct"> This is the correct answer
                        </label>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">Add Option</button>
                </form>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <div class="card-title">Options (<?php echo count($options); ?>)</div>
            </div>
            <div class="card-content">
                <?php if (count($options) > 0): ?>
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Option</th>
                                <th>Correct?</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($options as $opt): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($opt['option_text']); ?></td>
                                    <td>
                                        <?php if ($opt['is_correct']): ?>
                                            <span class="badge badge-success">✓ Correct</span>
                                        <?php else: ?>
                                            <span class="badge badge-secondary">✗ Incorrect</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <form method="POST" action="" style="display: inline;">
                                            <input type="hidden" name="action" value="delete_option">
                                            <input type="hidden" name="option_id" value="<?php echo $opt['id']; ?>">
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete this option?')">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p class="text-muted">No options added yet.</p>
                <?php endif; ?>
            </div>
        </div>
    <?php else: ?>
        <div class="alert alert-info">
            Short answer questions don't require predefined options. Answers will be reviewed manually.
        </div>
    <?php endif; ?>
    
    <a href="<?php echo BASE_URL; ?>admin/questions.php?questionnaire_id=<?php echo $q['questionnaire_id']; ?>" class="btn btn-outline">Back</a>
</div>

</body>
</html>
