<?php
require_once '../config.php';
require_once '../classes/Questionnaire.php';

if (!isAdmin()) {
    redirect(BASE_URL . 'auth/login.php');
}

$questionnaire = new Questionnaire($conn);
$message = '';
$error = '';

// Handle creation
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'create') {
    $title = sanitize($_POST['title'] ?? '');
    $description = sanitize($_POST['description'] ?? '');
    $duration = intval($_POST['duration_minutes'] ?? 30);
    $passing = intval($_POST['passing_percentage'] ?? 60);
    
    $result = $questionnaire->create($title, $description, $_SESSION['user_id'], $duration, $passing);
    
    if ($result['success']) {
        header("Location: " . BASE_URL . "admin/questionnaires.php");
        exit();
    } else {
        $error = 'Failed to create questionnaire';
    }
}

// Get all questionnaires
$questionnaires_result = $questionnaire->getAllQuestionnaires($_SESSION['user_id']);

$page_title = 'Questionnaires';
?>
<?php include '../includes/header.php'; ?>

<div class="container">
    <div class="card">
        <div class="card-header">
            <div class="card-title">Create New Questionnaire</div>
        </div>
        <div class="card-content">
            <?php if ($error): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <input type="hidden" name="action" value="create">
                
                <div class="form-group">
                    <label for="title">Title</label>
                    <input type="text" id="title" name="title" required>
                </div>
                
                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea id="description" name="description"></textarea>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="duration_minutes">Duration (minutes)</label>
                        <input type="number" id="duration_minutes" name="duration_minutes" value="30" min="1">
                    </div>
                    <div class="form-group">
                        <label for="passing_percentage">Passing Percentage</label>
                        <input type="number" id="passing_percentage" name="passing_percentage" value="60" min="0" max="100">
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">Create Questionnaire</button>
            </form>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <div class="card-title">My Questionnaires</div>
        </div>
        <div class="card-content">
            <?php if ($questionnaires_result->num_rows > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Questions</th>
                            <th>Duration</th>
                            <th>Passing %</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $questionnaires_result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['title']); ?></td>
                                <td><?php echo $row['total_questions']; ?></td>
                                <td><?php echo $row['duration_minutes']; ?> min</td>
                                <td><?php echo $row['passing_percentage']; ?>%</td>
                                <td>
                                    <?php if ($row['is_published']): ?>
                                        <span class="badge badge-success">Published</span>
                                    <?php else: ?>
                                        <span class="badge badge-secondary">Draft</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="table-actions">
                                        <a href="<?php echo BASE_URL; ?>admin/edit-questionnaire.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-primary">Edit</a>
                                        <a href="<?php echo BASE_URL; ?>admin/questions.php?questionnaire_id=<?php echo $row['id']; ?>" class="btn btn-sm btn-secondary">Questions</a>
                                        <a href="<?php echo BASE_URL; ?>admin/assign-students.php?questionnaire_id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline">Assign</a>
                                    </div>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-muted">No questionnaires created yet.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

</body>
</html>
