<?php
require_once '../config.php';
require_once '../classes/Report.php';

if (!isAdmin()) {
    redirect(BASE_URL . 'auth/login.php');
}

$quiz_id = intval($_GET['quiz_id'] ?? 0);
$report = new Report($conn);

$quiz_report = $report->getQuestionnaireReport($quiz_id);
if (!$quiz_report) {
    redirect(BASE_URL . 'admin/reports.php');
}

$students_result = $report->getQuestionnaireStudentResults($quiz_id);

$pass_rate = ($quiz_report['students_attempted'] > 0) ? 
            ($quiz_report['passed_count'] / $quiz_report['students_attempted']) * 100 : 0;

$page_title = 'Quiz Report';
?>
<?php include '../includes/header.php'; ?>

<div class="container">
    <div class="card">
        <div class="card-header">
            <div class="card-title">Quiz Report: <?php echo htmlspecialchars($quiz_report['title']); ?></div>
        </div>
    </div>
    
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-label">Students Attempted</div>
            <div class="stat-value"><?php echo $quiz_report['students_attempted']; ?></div>
        </div>
        
        <div class="stat-card">
            <div class="stat-label">Average Score</div>
            <div class="stat-value"><?php echo number_format($quiz_report['average_percentage'] ?? 0, 2); ?>%</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-label">Highest Score</div>
            <div class="stat-value"><?php echo number_format($quiz_report['highest_score'] ?? 0, 2); ?>%</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-label">Pass Rate</div>
            <div class="stat-value"><?php echo number_format($pass_rate, 2); ?>%</div>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <div class="card-title">Student Results</div>
        </div>
        <div class="card-content">
            <?php if ($students_result->num_rows > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Student Name</th>
                            <th>Email</th>
                            <th>Attempts</th>
                            <th>Best Score</th>
                            <th>Marks</th>
                            <th>Status</th>
                            <th>Last Attempt</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($student = $students_result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($student['full_name']); ?></td>
                                <td><?php echo htmlspecialchars($student['email']); ?></td>
                                <td><?php echo $student['attempts']; ?></td>
                                <td>
                                    <?php if ($student['best_score']): ?>
                                        <div class="progress" style="margin: 0;">
                                            <div class="progress-bar" style="width: <?php echo $student['best_score']; ?>%">
                                                <?php echo number_format($student['best_score'], 1); ?>%
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo $student['best_marks'] ? $student['best_marks'] . '/' . $student['total_marks'] : '-'; ?>
                                </td>
                                <td>
                                    <?php if ($student['status'] === 'Pass'): ?>
                                        <span class="badge badge-success">Pass</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger">Fail</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo $student['last_attempt'] ? date('M d, Y', strtotime($student['last_attempt'])) : '-'; ?>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-muted">No students have attempted this quiz yet.</p>
            <?php endif; ?>
        </div>
    </div>
    
    <a href="<?php echo BASE_URL; ?>admin/reports.php" class="btn btn-outline">Back to Reports</a>
</div>

</body>
</html>
