<?php
class Option {
    private $conn;
    private $table = 'options';
    
    public function __construct($db) {
        $this->conn = $db;
    }
    
    // Add option
    public function add($question_id, $option_text, $is_correct = 0) {
        $query = "SELECT MAX(option_order) as max_order FROM " . $this->table . " 
                  WHERE question_id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bind_param("i", $question_id);
        $stmt->execute();
        $result = $stmt->get_result()->fetch_assoc();
        $option_order = ($result['max_order'] ?? 0) + 1;
        
        $query = "INSERT INTO " . $this->table . " 
                  (question_id, option_text, is_correct, option_order) 
                  VALUES (?, ?, ?, ?)";
        $stmt = $this->conn->prepare($query);
        $stmt->bind_param("isii", $question_id, $option_text, $is_correct, $option_order);
        
        if ($stmt->execute()) {
            return array('success' => true, 'id' => $this->conn->insert_id);
        }
        return array('success' => false);
    }
    
    // Get options by question
    public function getByQuestion($question_id) {
        $query = "SELECT * FROM " . $this->table . " 
                  WHERE question_id = ? 
                  ORDER BY option_order";
        $stmt = $this->conn->prepare($query);
        $stmt->bind_param("i", $question_id);
        $stmt->execute();
        return $stmt->get_result();
    }
    
    // Update option
    public function update($id, $option_text, $is_correct) {
        $query = "UPDATE " . $this->table . " 
                  SET option_text = ?, is_correct = ? 
                  WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bind_param("sii", $option_text, $is_correct, $id);
        
        if ($stmt->execute()) {
            return array('success' => true);
        }
        return array('success' => false);
    }
    
    // Delete option
    public function delete($id) {
        $query = "DELETE FROM " . $this->table . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bind_param("i", $id);
        
        if ($stmt->execute()) {
            return array('success' => true);
        }
        return array('success' => false);
    }
    
    // Get option by ID
    public function getById($id) {
        $query = "SELECT * FROM " . $this->table . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bind_param("i", $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }
}
?>
