<?php
class Question {
    private $conn;
    private $table = 'questions';
    
    public function __construct($db) {
        $this->conn = $db;
    }
    
    // Add question
    public function add($questionnaire_id, $question_text, $question_type, $marks) {
        $query = "SELECT MAX(display_order) as max_order FROM " . $this->table . " 
                  WHERE questionnaire_id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bind_param("i", $questionnaire_id);
        $stmt->execute();
        $result = $stmt->get_result()->fetch_assoc();
        $display_order = ($result['max_order'] ?? 0) + 1;
        
        $query = "INSERT INTO " . $this->table . " 
                  (questionnaire_id, question_text, question_type, marks, display_order) 
                  VALUES (?, ?, ?, ?, ?)";
        $stmt = $this->conn->prepare($query);
        $stmt->bind_param("issii", $questionnaire_id, $question_text, $question_type, $marks, $display_order);
        
        if ($stmt->execute()) {
            return array('success' => true, 'id' => $this->conn->insert_id);
        }
        return array('success' => false);
    }
    
    // Get question by ID with options
    public function getById($id) {
        $query = "SELECT * FROM " . $this->table . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $question = $stmt->get_result()->fetch_assoc();
        
        if ($question) {
            // Get options
            $query = "SELECT * FROM options WHERE question_id = ? ORDER BY option_order";
            $stmt = $this->conn->prepare($query);
            $stmt->bind_param("i", $id);
            $stmt->execute();
            $question['options'] = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
        }
        
        return $question;
    }
    
    // Get all questions for a questionnaire
    public function getByQuestionnaire($questionnaire_id) {
        $query = "SELECT * FROM " . $this->table . " 
                  WHERE questionnaire_id = ? 
                  ORDER BY display_order ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->bind_param("i", $questionnaire_id);
        $stmt->execute();
        return $stmt->get_result();
    }
    
    // Update question
    public function update($id, $question_text, $marks) {
        $query = "UPDATE " . $this->table . " 
                  SET question_text = ?, marks = ? 
                  WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bind_param("sii", $question_text, $marks, $id);
        
        if ($stmt->execute()) {
            return array('success' => true);
        }
        return array('success' => false);
    }
    
    // Delete question
    public function delete($id) {
        $query = "DELETE FROM " . $this->table . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bind_param("i", $id);
        
        if ($stmt->execute()) {
            return array('success' => true);
        }
        return array('success' => false);
    }
    
    // Reorder questions
    public function reorder($questionnaire_id, $question_order) {
        foreach ($question_order as $order => $question_id) {
            $query = "UPDATE " . $this->table . " 
                      SET display_order = ? 
                      WHERE id = ? AND questionnaire_id = ?";
            $stmt = $this->conn->prepare($query);
            $stmt->bind_param("iii", $order, $question_id, $questionnaire_id);
            $stmt->execute();
        }
        return array('success' => true);
    }
}
?>
