<?php
require_once '../config.php';
require_once '../classes/QuizAttempt.php';

if (!isStudent()) {
    redirect(BASE_URL . 'auth/login.php');
}

$quiz_attempt = new QuizAttempt($conn);
$student_id = $_SESSION['user_id'];

$attempts_result = $quiz_attempt->getStudentAttempts($student_id);

$page_title = 'My Progress';
?>
<?php include '../includes/header.php'; ?>

<div class="container">
    <h1>My Progress</h1>
    
    <div class="card">
        <div class="card-header">
            <div class="card-title">Quiz Attempts History</div>
        </div>
        <div class="card-content">
            <?php if ($attempts_result->num_rows > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Quiz Title</th>
                            <th>Attempt Date</th>
                            <th>Score</th>
                            <th>Percentage</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($attempt = $attempts_result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($attempt['questionnaire_title']); ?></td>
                                <td><?php echo date('M d, Y H:i', strtotime($attempt['created_at'])); ?></td>
                                <td><?php echo $attempt['obtained_marks']; ?>/<?php echo $attempt['total_marks']; ?></td>
                                <td>
                                    <div class="progress" style="margin: 0;">
                                        <div class="progress-bar" style="width: <?php echo $attempt['percentage']; ?>%">
                                            <?php echo number_format($attempt['percentage'], 1); ?>%
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <?php if ($attempt['percentage'] >= 60): ?>
                                        <span class="badge badge-success">Pass</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger">Fail</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo BASE_URL; ?>student/quiz-result.php?attempt_id=<?php echo $attempt['id']; ?>" class="btn btn-sm btn-primary">Review</a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-muted">You haven't completed any quizzes yet. <a href="<?php echo BASE_URL; ?>student/dashboard.php">Start a quiz now!</a></p>
            <?php endif; ?>
        </div>
    </div>
</div>

</body>
</html>
